<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CashStatement extends Model 
{

    protected $table = 'cash_statements';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_box_id', 'admin_id', 'end_id', 'auditor_user_id', 'sender_user_id', 'beneficiary_user_id', 'slug', 'uv', 'type', 'date', 'open_to', 'start', 'end', 'audit_comment', 'audit_status', 'rejet', 'rejet_description', 'status');
    protected $visible = array('user_box_id', 'admin_id', 'end_id', 'auditor_user_id', 'sender_user_id', 'beneficiary_user_id', 'slug', 'uv', 'type', 'date', 'open_to', 'start', 'end', 'audit_comment', 'audit_status', 'rejet', 'rejet_description', 'status');

    public function CashBands()
    {
        return $this->hasMany('App\Models\CashBand', 'cash_statement_id');
    }

    public function userBox()
    {
        return $this->belongsTo('App\Models\UserBox', 'user_box_id');
    }

    public function admin()
    {
        return $this->belongsTo('App\Models\User', 'admin_id');
    }

    public function end()
    {
        return $this->belongsTo('App\Models\CashStatement', 'end_id')->where('end',1);
    }

    public function start()
    {
        return $this->hasOne('App\Models\CashStatement', 'end_id')->where('start',1);
    }

    public function auditorUser()
    {
        return $this->belongsTo('App\Models\User', 'auditor_user_id');
    }

    public function amountCashStatementCurrency()
    {
        return $this->hasMany('App\Models\AmountCashStatementCurrency', 'cash_statement_id');
    }

    public function sender()
    {
        return $this->belongsTo('App\Models\User', 'sender_user_id');
    }

    public function beneficiary()
    {
        return $this->belongsTo('App\Models\User', 'beneficiary_user_id');
    }

    public function auditReports()
    {
        return $this->hasMany('App\Models\AuditReport', 'cash_statement_id');
    }

}